<?php

function display_shows($param, $value, $sort, $past) {

	require("showdbsettings.php");
	$myConnection = mysqli_connect("$db_host","$db_user","$db_password") or die('Could not connect: ' . mysqli_connect_error());
	mysqli_select_db($myConnection, "$db_name") or die('Could not select database');

	global $showdbadmin, $db_recordings, $sourceinfopath, $soundclippath;

	if ($sort == "venue")
		$sortcode = "venue_name ASC,";
	elseif ($sort == "location")
		$sortcode = "mastervenues.venue_country ASC, mastervenues.venue_state ASC, mastervenues.venue_city ASC,";
	elseif ($sort == "artist")
		$sortcode = "artist_name ASC,";
	else
		$sortcode = "";

	if ($past)
		$sortcode2 = "$sortcode mastershows.show_epoch DESC, mastershows.show_id DESC,";
	else
		$sortcode2 = "$sortcode mastershows.show_epoch ASC, mastershows.show_id ASC,";

	$shows_query = mysqli_query($myConnection, "SELECT mastershows.show_id, mastershows.show_epoch, IF(mastershows.alternate_venue!='',mastershows.alternate_venue,mastervenues.venue_name) AS venue_name, mastershows.venue_id, mastershows.show_year, mastershows.show_month, mastershows.show_day, mastervenues.venue_city, mastervenues.venue_state, mastervenues.venue_country, masterartists.artist_id, IF(artistshows.alternate_name!='',artistshows.alternate_name,masterartists.artist_name) AS artist_name, artistshows.source_info, artistshows.sound_clip, artistshows.archive_link FROM mastershows LEFT JOIN mastervenues ON mastershows.venue_id = mastervenues.venue_id LEFT JOIN artistshows ON artistshows.show_id = mastershows.show_id LEFT JOIN masterartists ON masterartists.artist_id = artistshows.artist_id WHERE $param = '$value' AND past = '$past' ORDER BY $sortcode2 artistshows.number ASC") or die('Query failed: ' . mysqli_error($myConnection));

	$numshows_query = mysqli_query($myConnection, "SELECT mastershows.show_id FROM mastershows LEFT JOIN artistshows ON artistshows.show_id = mastershows.show_id WHERE $param = '$value' AND past = '$past' GROUP BY mastershows.show_id") or die('Query failed: ' . mysqli_error($myConnection));
	$numshows = mysqli_num_rows($numshows_query);

	if ($past)
		echo "<p>\nPast Shows: $numshows\n</p>\n";
	else
		echo "<p>\nUpcoming Shows: $numshows\n</p>\n";

	if ($numshows > 0) {
		$self = $_SERVER['PHP_SELF'] . '?' . $_SERVER['QUERY_STRING'];
		if (!strpos($self, "sort=")) {
			if (!strpos($self, "?"))
				$self = $self . "?sort=temp";
			else
				$self = $self . "&amp;sort=temp";
		}
		$sorts = array("sort=artist", "sort=date", "sort=venue", "sort=location", "sort=temp");
		$sortartist = str_replace($sorts, "sort=artist", $self);
		$sortdate = str_replace($sorts, "sort=date", $self);
		$sortvenue = str_replace($sorts, "sort=venue", $self);
		$sortlocation = str_replace($sorts, "sort=location", $self);

		echo "<table class=\"shows\">\n";
		echo "<tr>\n";
		echo "<th><a href=\"$sortdate\">Date</a></th><th><a href=\"$sortvenue\">Venue</a></th><th><a href=\"$sortlocation\">Location</a></th><th><a href=\"$sortartist\">Artists</a></th>\n";
		if ($db_recordings)
			echo "<th>Taped?</th><th>Sample?</th><th>Download?</th>";
		if ($showdbadmin)
			echo "<th>Options</th>";
		echo "</tr>\n";

		while ($shows = mysqli_fetch_array($shows_query)) {
			if ($db_recordings) {
				if ($shows['source_info'] <> "") {
					if (substr($shows['source_info'], 0, 7) == "http://")
						$sourcefile = $shows['source_info'];
					else
						$sourcefile = $sourceinfopath . $shows['source_info'];
					$sourceinfo = "<td><a href=\"$sourcefile\">Yes</a></td>";
				}
				else
					$sourceinfo = "<td>No</td>";
				if ($shows['sound_clip'] <> "") {
					if (substr($shows['sound_clip'], 0, 7) == "http://")
						$soundfile = $shows['sound_clip'];
					else
						$soundfile = $soundclippath . $shows['sound_clip'];
					$soundclip = "<td><a href=\"$soundfile\">Yes</a></td>";
				}
				else
					$soundclip = "<td>No</td>";
				if ($shows['archive_link'] <> "")
					$archivelink = "<td><a href=\"$shows[archive_link]\" target=\"_blank\">Yes</a></td>";
				else
					$archivelink = "<td>No</td>";
			}
			if ($shows['show_id'] == $pastshowid AND $sort <> "artist") {
				echo "<tr class=\"sameshow\">\n<td></td><td></td><td></td><td><a href=\"artist.php?artistID=$shows[artist_id]\">$shows[artist_name]</a></td>";
				if ($db_recordings)
					echo "$sourceinfo$soundclip$archivelink";
				echo "\n</tr>\n";
			}
			else {
				$displaydate = date("m.d.Y", $shows['show_epoch']);
				$location = $shows['venue_city'];
				if ($shows['venue_state'] <> "")
					$location = $location . ', ' . $shows['venue_state'];
				if ($shows['venue_country'] <> "")
					$location = $location . ', ' . $shows['venue_country'];
				echo "<tr class=\"newshow\">\n<td><a href=\"show.php?showID=$shows[show_id]\">$displaydate</a></td><td><a href=\"venue.php?venueID=$shows[venue_id]\">$shows[venue_name]</a></td><td>$location</td><td><a href=\"artist.php?artistID=$shows[artist_id]\">$shows[artist_name]</a></td>";
				if ($db_recordings)
					echo "$sourceinfo$soundclip$archivelink";
				if ($showdbadmin) {
					echo "<td><a href=\"adminshow.php?action=edit&amp;showID=$shows[show_id]\">edit</a> <a href=\"adminshow.php?action=delete&amp;showID=$shows[show_id]&amp;delstate=1\">delete</a>";
					if ($past == 0)
						echo " <a href=\"adminshow.php?action=went&amp;showID=$shows[show_id]\">went</a>";
					echo "</td>";
				}
				echo "\n</tr>\n";
			}
			$pastshowid = $shows['show_id'];
		}

		echo "</table>\n";
	}
	
	mysqli_close($myConnection);
}

?>

